package joyfill.chart.internal

import joyfill.chart.Point
import joyfill.internal.AbstractMappable
import joyfill.utils.ID
import joyfill.utils.toNonNullableString
import joyfill.utils.toNullableDouble

@PublishedApi
internal class PointImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractMappable(wrapped), Point {

    override val id by lazy { wrapped[ID].toString() }
    override var label: String?
        get() = wrapped[Point::label.name].toNonNullableString()
        set(value) {
            wrapped[Point::label.name] = value
        }

    override var x: Double
        get() = wrapped[Point::x.name]?.toNullableDouble() ?: 0.0
        set(value) {
            wrapped[Point::x.name] = value
        }

    override var y: Double
        get() = wrapped[Point::y.name]?.toNullableDouble() ?: 0.0
        set(value) {
            wrapped[Point::y.name] = value
        }
} 