package joyfill.chart.internal

import joyfill.chart.ChartField
import joyfill.chart.Line
import joyfill.chart.toLine
import joyfill.internal.AbstractListBasedField
import joyfill.utils.AXIS_X_MAX
import joyfill.utils.AXIS_X_MIN
import joyfill.utils.AXIS_X_TITLE
import joyfill.utils.AXIS_Y_MAX
import joyfill.utils.AXIS_Y_MIN
import joyfill.utils.AXIS_Y_TITLE
import joyfill.utils.toNonNullableString
import joyfill.utils.toNullableDouble

@PublishedApi
internal class ChartFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedField<Line>(wrapped), ChartField {
    override fun factory(map: MutableMap<String, Any?>): Line = map.toLine()

    override val xTitle: String? get() = wrapped[AXIS_X_TITLE].toNonNullableString()
    override val yTitle: String? get() = wrapped[AXIS_Y_TITLE].toNonNullableString()
    override val xMin: Double? get() = wrapped[AXIS_X_MIN]?.toNullableDouble()
    override val xMax: Double? get() = wrapped[AXIS_X_MAX]?.toNullableDouble()
    override val yMin: Double? get() = wrapped[AXIS_Y_MIN]?.toNullableDouble()
    override val yMax: Double? get() = wrapped[AXIS_Y_MAX]?.toNullableDouble()
} 