package joyfill.chart

import joyfill.chart.internal.ChartFieldImpl
import joyfill.chart.internal.LineImpl
import joyfill.chart.internal.PointImpl
import joyfill.utils.ID

inline fun MutableMap<String, Any?>.toChartField(): ChartField = ChartFieldImpl(this)

inline fun MutableMap<String, Any?>.toLine(): Line = LineImpl(this)

inline fun MutableMap<String, Any?>.toPoint(): Point = PointImpl(this)

inline fun Line(
    id: String,
    title: String,
    description: String? = null,
    points: MutableList<MutableMap<String, Any?>> = mutableListOf(),
    deleted: Boolean = false,
) = mutableMapOf(
    ID to id,
    Line::title.name to title,
    Line::description.name to description,
    Line::points.name to points,
    Line::deleted.name to deleted,
).toLine()

inline fun Point(
    id: String,
    label: String? = null,
    x: Double = 0.0,
    y: Double = 0.0,
) = mutableMapOf<String, Any?>(
    ID to id,
    Point::label.name to label,
    Point::x.name to x,
    Point::y.name to y,
).toPoint()
