@file:Suppress("ClassName")

package joyfill

// When you add a new type, remember to add it in the entries list below as well
sealed interface Type {
    val name: String

    data object text : Type {
        override val name = "text"
    }

    data object textarea : Type {
        override val name = "textarea"
    }

    data object number : Type {
        override val name = "number"
    }

    data object dropdown : Type {
        override val name = "dropdown"
    }

    data object multiSelect : Type {
        override val name = "multiSelect"
    }

    data object date : Type {
        override val name = "date"
    }

    data object richText : Type {
        override val name = "richText"
    }

    data object signature : Type {
        override val name = "signature"
    }

    data object table : Type {
        override val name = "table"
    }

    data object collection : Type {
        override val name = "collection"
    }

    data object chart : Type {
        override val name = "chart"
    }

    data object image : Type {
        override val name = "image"
    }

    data object file : Type {
        override val name = "file"
    }

    data object block : Type {
        override val name = "block"
    }

    data object progress : Type {
        override val name = "progress"
    }

    data object barcode : Type {
        override val name = "barcode"
    }

    data class unknown(override val name: String) : Type {
        companion object {
            const val name = "Unknown"
        }
    }

    companion object {
        val entries = listOf(
            text,
            textarea,
            number,
            dropdown,
            multiSelect,
            date,
            richText,
            signature,
            table,
            collection,
            chart,
            image,
            file,
            block,
            progress,
            barcode
        ).associateBy { it.name.lowercase() }.toMutableMap()

        fun valueOf(name: String = unknown.name): Type = entries.getOrPut(name.lowercase()) { unknown(name) }
    }
}