package joyfill

/**
 * Interface for handling errors within the SDK
 */
fun interface ErrorHandler {
    /**
     * Called when any error occurs
     *
     * @param error The error that occurred
     */
    fun onError(error: Error)
}

val NoOpErrorHandler = ErrorHandler { _ -> }