package joyfill2.utils.internal

import joyfill2.internal.AbstractMappable
import joyfill2.table.Cells
import joyfill2.table.Column
import joyfill2.table.Row
import joyfill2.table.internal.CellsImpl
import joyfill2.utils.ID

@PublishedApi
internal abstract class AbstractRowImpl(
    columns: List<Column>,
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Row {
    override val id: String = wrapped[ID] as String
    override val cells: Cells by lazy {
        val cells: MutableMap<String, Any?> = when (val cellsValue = wrapped[Row::cells.name]) {
            is MutableMap<*, *> -> cellsValue as MutableMap<String, Any?>
            else -> mutableMapOf()
        }
        CellsImpl(columns, cells)
    }
    override val deleted: Boolean by lazy { wrapped[Row::deleted.name] as? Boolean == true }
}