package joyfill2.utils

import joyfill2.Mappable
import kotlin.reflect.KProperty

internal fun <T : Mappable> JsonList(
    parent: MutableMap<String, Any?>,
    key: KProperty<List<T>>,
    factory: (MutableMap<String, Any?>) -> T
): MutableList<T> {
    if (parent[key.name] !is MutableList<*>) {
        parent[key.name] = mutableListOf<MutableMap<String, Any?>>()
    }
    return JsonList(parent[key.name] as MutableList<MutableMap<String, Any?>>, factory)
}

internal fun <T : Mappable> MutableMap<String, Any?>.listAt(
    key: KProperty<List<T>>,
    factory: (MutableMap<String, Any?>) -> T
): MutableList<T> = JsonList(this, key, factory)