package joyfill2.tooltip.internal

import joyfill2.internal.AbstractMappable
import joyfill2.tooltip.ToolTip
import joyfill2.utils.TIP_DESCRIPTION
import joyfill2.utils.TIP_TITLE
import joyfill2.utils.TIP_VISIBLE
import joyfill2.utils.toNullableString

internal class ToolTipImpl(
    private val wrapper: MutableMap<String, Any?>,
) : AbstractMappable(wrapper),
    ToolTip {

    override var title: String
        get() = wrapper[TIP_TITLE].toNullableString().orEmpty()
        set(value) {
            wrapper[TIP_TITLE] = value
        }

    override var visible: Boolean
        get() = wrapper[TIP_VISIBLE]?.toString()?.toBoolean() == true
        set(value) {
            wrapper[TIP_VISIBLE] = value
        }

    override var description: String
        get() = wrapper[TIP_DESCRIPTION].toNullableString().orEmpty()
        set(value) {
            wrapper[TIP_DESCRIPTION] = value
        }
}
