package joyfill2.text_area.internal

import joyfill2.components.Component
import joyfill2.internal.AbstractValueBasedField
import joyfill2.text_area.TextAreaField
import joyfill2.utils.toNullableString

@PublishedApi
internal class TextAreaFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), TextAreaField{
    override var value: String?
        get() = wrapped[Component::value.name].toNullableString()
        set(value) {
            wrapped[Component::value.name] = value
        }
}