package joyfill2.text.internal

import joyfill2.components.Component
import joyfill2.internal.AbstractValueBasedField
import joyfill2.text.TextField
import joyfill2.utils.toNullableString

@PublishedApi
internal class TextFieldImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractValueBasedField<String>(wrapped),
    TextField {
    override var value: String?
        get() = wrapped[Component::value.name].toNullableString()
        set(value) {
            wrapped[Component::value.name] = value
        }
}
