package joyfill2.number.internal

import joyfill2.number.NumberColumn
import joyfill2.table.internal.column.AbstractValueBasedColumn
import joyfill2.utils.toNullableDouble

@PublishedApi
internal class NumberColumnImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedColumn<Double>(wrapped), NumberColumn {
    override var value: Double?
        get() = wrapped[NumberColumn::value.name]?.toNullableDouble()
        set(value) {
            wrapped[NumberColumn::value.name] = value
        }
}