package joyfill2.multi_select.internal

import joyfill2.internal.AbstractField
import joyfill2.multi_select.MultiSelectField
import joyfill2.utils.JsonList
import joyfill2.utils.Option
import joyfill2.utils.toOption

@PublishedApi
internal class MultiSelectFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractField(wrapped), MultiSelectField {
    override val multi by lazy {
        wrapped[MultiSelectField::multi.name]?.toString()?.toBoolean() ?: true
    }

    override val options: List<Option> =
        JsonList(wrapped[MultiSelectField::options.name]) { it.toOption() }

    override val value: MutableList<String> = run {
        val key = MultiSelectField::value.name
        val v = wrapped[key] as? MutableList<String>
        if (v == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }
}