package joyfill2.internal

import joyfill.utils.ID
import joyfill2.FormulaDefinition
import joyfill2.FormulaScope

@PublishedApi
internal class FormularDefinitionImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), FormulaDefinition {
    override val id: String by lazy { wrapped[ID].toString() }

    override val desc: String by lazy { wrapped[FormulaDefinition::desc.name].toString() }

    override val type: String by lazy { wrapped[FormulaDefinition::type.name].toString() }

    override val scope: FormulaScope by lazy {
        try {
            FormulaScope.valueOf(wrapped[FormulaDefinition::scope.name] as String)
        } catch (_: Throwable) {
            FormulaScope.Global
        }
    }

    override val formula: String by lazy { wrapped[FormulaDefinition::formula.name].toString() }
}