package joyfill2.internal

import joyfill.utils.ID
import joyfill2.FormulaDefinition
import joyfill2.FormularApplication
import joyfill2.FormularTarget

@PublishedApi
internal class FormularApplicationImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), FormularApplication {
    override val id: String by lazy { wrapped[ID].toString() }
    override val formula: String by lazy { wrapped[FormulaDefinition::formula.name].toString() }
    override val key: FormularTarget by lazy {
        try {
            FormularTarget.valueOf(wrapped[FormularApplication::key.name] as String)
        } catch (_: Throwable) {
            FormularTarget.Value
        }
    }
}