package joyfill2.image.internal

import joyfill2.image.ImageField
import joyfill2.internal.AbstractListBasedField
import joyfill2.utils.Attachment
import joyfill2.utils.toAttachment

@PublishedApi
internal class ImageFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedField<Attachment>(wrapped), ImageField {
    override fun factory(map: MutableMap<String, Any?>): Attachment = map.toAttachment()
    override val multi: Boolean by lazy {
        wrapped[ImageField::multi.name]?.toString()?.toBooleanStrict() ?: true
    }
}