package joyfill2.dropdown.internal

import joyfill2.dropdown.DropdownCell
import joyfill2.dropdown.DropdownColumn
import joyfill2.dropdown.DropdownSchema

@PublishedApi
internal class DropdownCellImpl(
    override val column: DropdownColumn,
    private val wrapped: MutableMap<String, Any?>
) : DropdownCell, DropdownSchema by column {
    override var value: String?
        get() = wrapped[column.id] as? String
        set(value) {
            wrapped[column.id] = value
        }
}