package joyfill2.conditions.internal

import joyfill2.conditions.AndEval
import joyfill2.conditions.HideAction
import joyfill2.conditions.Logic
import joyfill2.conditions.OrEval
import joyfill2.conditions.ShowAction
import joyfill2.conditions.UnknownAction
import joyfill2.conditions.UnknownEval
import joyfill2.internal.AbstractMappable

@PublishedApi
internal abstract class AbstractLogicImpl(
    wrapped: MutableMap<String, Any?>
) : Logic, AbstractMappable(wrapped) {
    override val action get() = wrapped[Logic::action.name].toAction()
    override val eval get() = wrapped[Logic::eval.name].toEval()

    override var hidden: Boolean
        get() = wrapped[Logic::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Logic::hidden.name] = value
        }

    private fun Any?.toAction() = when (this) {
        "show" -> ShowAction
        "hide" -> HideAction
        else -> UnknownAction(this)
    }

    private fun Any?.toEval() = when (this) {
        "and" -> AndEval
        "or" -> OrEval
        else -> UnknownEval(this)
    }
}