package joyfill2.collection.internal

import joyfill2.collection.TableSchemas
import joyfill2.internal.AbstractMappable
import joyfill2.table.TableSchema

@PublishedApi
internal class TableSchemasImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), TableSchemas {
    override fun all(): List<TableSchema> = wrapped.map { (key, value) -> TableSchemaImpl(id = key, value as MutableMap<String, Any?>) }

    override fun table(key: String?): TableSchema? = all().find { it.id == key || it.title.contentEquals(key, ignoreCase = true) }

    override fun root(): TableSchema? = all().find { it.root }
}