package joyfill2.collection.internal

import joyfill2.collection.Children
import joyfill2.collection.TableSchemas
import joyfill2.table.Row
import joyfill2.table.TableSchema
import joyfill2.utils.internal.AbstractRowImpl

@PublishedApi
internal class RowImpl(
    schema: TableSchemas,
    table: TableSchema,
    wrapped: MutableMap<String, Any?>
) : AbstractRowImpl(table.columns, wrapped), Row {

    override val children: Children by lazy {
        if (wrapped[Row::children.name] == null) {
            wrapped[Row::children.name] = mutableMapOf<String, Any?>()
        }
        ChildrenImpl(schema, table, wrapped[Row::children.name] as MutableMap<String, Any?>)
    }
}