package joyfill2.collection.internal

import joyfill2.collection.Child
import joyfill2.collection.TableSchemas
import joyfill2.schemas.internal.AbstractSchema
import joyfill2.table.Row
import joyfill2.table.TableSchema
import joyfill2.utils.JsonList

internal class ChildImpl(
    private val schema: TableSchemas,
    private val table: TableSchema,
    wrapped: MutableMap<String, Any?>
) : AbstractSchema(wrapped), Child {

    override val value: MutableList<Row> by lazy {
        val key = Child::value.name
        if (wrapped[key] !is List<*>) {
            wrapped[key] = mutableListOf<MutableMap<String, Any>>()
        }
        JsonList(wrapped[key]) {
            RowImpl(
                schema = schema,
                table = table,
                wrapped = it
            )
        }
    }
}