package joyfill.fields.table.internal

import joyfill.fields.AbstractMappable
import joyfill.fields.Field
import joyfill.fields.table.Column
import joyfill.type
import joyfill.utils.ID

abstract class AbstractColumn(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Column {
    override val id: String by lazy { wrapped[ID] as String }
    override val title: String by lazy { wrapped[Column::title.name] as String }
    override val type: Field.Type by lazy { wrapped.type() }
    override val required: Boolean by lazy {
        wrapped[Column::required.name]?.toString()?.lowercase()?.toBooleanStrictOrNull() == true
    }
}