package joyfill.fields.table

import joyfill.Mappable
import joyfill.fields.Field
import joyfill.utils.Attachment
import joyfill.utils.Option2

interface Column : Mappable {
    val id: String
    val title: String
    val type: Field.Type
    val required: Boolean
}

interface TextColumn : Column {
    val value: String?
}

interface DateColumn : Column {
    val value: Long?
}

interface BlockColumn : Column {
    val value: String?
}

interface NumberColumn : Column {
    val value: Double?
}

interface DropdownColumn : Column {
    val options: List<Option2>
    val value: String?
}

interface MultiselectColumn : Column {
    val options: List<Option2>
    val value: List<String>
    val multi: Boolean
}

interface ImageColumn : Column {
    val value: List<Attachment>
}

interface ProgressColumn : Column {
}

interface BarcodeColumn : Column {
    val value: String?
}

interface SignatureColumn : Column {
    val value: String?
}

interface UnknownColumn : Column