package joyfill.fields.internal

import joyfill.fields.TextAreaField
import joyfill.utils.toNullableString

@PublishedApi
internal class TextAreaFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), TextAreaField {
    override var value: String?
        get() = wrapped[TextAreaField::value.name]?.toNullableString()
        set(value) {
            wrapped[TextAreaField::value.name] = value
        }
}