package joyfill.fields.internal

import joyfill.fields.AbstractField
import joyfill.fields.DropdownField
import joyfill.fields.MultiSelectField
import joyfill.utils.JsonList
import joyfill.utils.Option2
import joyfill.utils.toOption

@PublishedApi
internal open class MultiSelectFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractField(wrapped), MultiSelectField {
    override val multi: Boolean by lazy {
        wrapped[MultiSelectField::multi.name]?.toString()?.toBooleanStrict() ?: true
    }
    override val options: List<Option2> = JsonList(wrapped[DropdownField::options.name]) { it.toOption() }
    override val value: MutableList<String> = run {
        val key = MultiSelectField::value.name
        val v = wrapped[key] as? MutableList<String>
        if (v == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }
}