package joyfill2.utils.internal

import joyfill2.internal.AbstractMappable
import joyfill2.utils.Attachment
import joyfill2.utils.ID
import joyfill2.utils.toAttachment

internal class AttachmentImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Attachment {
    override val id get() = wrapped[ID] as String

    override val url get() = wrapped[Attachment::url.name] as String

    override val fileName get() = wrapped[Attachment::fileName.name] as? String

    override val filePath get() = wrapped[Attachment::filePath.name] as? String

    override val download: String = (wrapped[Attachment::download.name] as? String) ?: url

    override fun copy(id: String, url: String, fileName: String?): Attachment {
        val newWrapped = wrapped.toMutableMap().apply {
            put(ID, id)
            put(Attachment::url.name, url)
            put(Attachment::fileName.name, fileName)
        }
        return newWrapped.toAttachment()
    }

    override fun toString(): String {
        return "Attachment(id='$id', url='$url', name=$fileName, path=$filePath, download='$download')"
    }
}