package joyfill2.utils

internal fun Any?.toNullableDouble(): Double? = when (this) {
    is Double -> this
    is Long -> this.toDouble()
    is Int -> this.toDouble()
    is Float -> this.toDouble()
    is String -> this.toDoubleOrNull()
    else -> null
}

internal fun Any?.toNullableString(): String? = when (this) {
    is Double, is Long, is Int, is Float -> this.toString()
    is String -> this
    else -> null
}