package joyfill2.text.internal

import joyfill2.text.TextCell
import joyfill2.text.TextColumn
import joyfill2.text.TextSchema
import joyfill2.utils.toNullableString

@PublishedApi
internal class TextCellImpl(
    override val column: TextColumn,
    private val wrapped: MutableMap<String, Any?>
) : TextCell, TextSchema by column {
    override var value: String?
        get() = wrapped[column.id].toNullableString()
        set(value) {
            wrapped[column.id] = value
        }
}