package joyfill2.table.internal.column

import joyfill2.Mappable
import joyfill2.components.Component
import joyfill2.utils.JsonList
import joyfill2.value.ListValue

@PublishedApi
internal abstract class AbstractListBasedColumn<V : Mappable>(
    wrapped: MutableMap<String, Any?>
) : AbstractColumn(wrapped), ListValue<V> {
    abstract fun factory(map: MutableMap<String, Any?>): V
    override val value: MutableList<V> = run {
        val key = Component::value.name
        val item = wrapped[key]
        if (item !is List<*>) {
            wrapped[key] = mutableListOf<MutableMap<String, Any>>()
        }
        return@run JsonList(wrapped[key]) { factory(it) }
    }
}