package joyfill2.table.internal

import joyfill2.barcode.BarcodeCell
import joyfill2.block.BlockCell
import joyfill2.date.DateCell
import joyfill2.dropdown.DropdownCell
import joyfill2.file.FileCell
import joyfill2.image.ImageCell
import joyfill2.internal.AbstractMappable
import joyfill2.multi_select.MultiSelectCell
import joyfill2.number.NumberCell
import joyfill2.signature.SignatureCell
import joyfill2.table.Cell
import joyfill2.table.Cells
import joyfill2.table.Column
import joyfill2.table.toCell
import joyfill2.text.TextCell
import joyfill2.text_area.TextAreaCell

@PublishedApi
internal class CellsImpl(
    private val columns: List<Column>,
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Cells {

    private fun look(key: String?): Column? = columns.find { it.id == key || it.title.contentEquals(key, ignoreCase = true) }

    override fun find(key: String?): Cell? {
        val column = look(key) ?: return null
        return wrapped.toCell(column)
    }

    override fun text(key: String?): TextCell? = find(key) as? TextCell

    override fun signature(key: String?): SignatureCell? = find(key) as? SignatureCell

    override fun block(key: String?): BlockCell? = find(key) as? BlockCell

    override fun dropdown(key: String?): DropdownCell? = find(key) as? DropdownCell

    override fun barcode(key: String?): BarcodeCell? = find(key) as? BarcodeCell

    override fun multiSelect(key: String?): MultiSelectCell? = find(key) as? MultiSelectCell

    override fun textArea(key: String?): TextAreaCell? = find(key) as? TextAreaCell

    override fun number(key: String?): NumberCell? = find(key) as? NumberCell

    override fun date(key: String?): DateCell? = find(key) as? DateCell

    override fun image(key: String?): ImageCell? = find(key) as? ImageCell

    override fun file(key: String?): FileCell? = find(key) as? FileCell

    override fun all(): List<Cell> = columns.mapNotNull { find(it.id) }
}

