package joyfill2.table

import joyfill2.Type
import joyfill2.barcode.BarcodeColumn
import joyfill2.barcode.internal.BarcodeCellImpl
import joyfill2.barcode.internal.BarcodeColumnImpl
import joyfill2.block.BlockColumn
import joyfill2.block.internal.BlockCellImpl
import joyfill2.block.internal.BlockColumnImpl
import joyfill2.collection.TableSchemas
import joyfill2.collection.internal.TableSchemasImpl
import joyfill2.date.DateColumn
import joyfill2.date.internal.DateCellImpl
import joyfill2.date.internal.DateColumnImpl
import joyfill2.dropdown.DropdownColumn
import joyfill2.dropdown.internal.DropdownCellImpl
import joyfill2.dropdown.internal.DropdownColumnImpl
import joyfill2.file.FileColumn
import joyfill2.file.internal.FileCellImpl
import joyfill2.file.internal.FileColumnImpl
import joyfill2.image.ImageColumn
import joyfill2.image.internal.ImageCellImpl
import joyfill2.image.internal.ImageColumnImpl
import joyfill2.multi_select.MultiSelectColumn
import joyfill2.multi_select.internal.MultiSelectCellImpl
import joyfill2.multi_select.internal.MultiSelectColumnImpl
import joyfill2.number.NumberColumn
import joyfill2.number.internal.NumberCellImpl
import joyfill2.number.internal.NumberColumnImpl
import joyfill2.signature.SignatureColumn
import joyfill2.signature.internal.SignatureCellImpl
import joyfill2.signature.internal.SignatureColumnImpl
import joyfill2.table.internal.CellsImpl
import joyfill2.table.internal.RowImpl
import joyfill2.table.internal.TableFieldImpl
import joyfill2.table.internal.column.ColumnVisualPropertiesImpl
import joyfill2.table.internal.table.ColumnVisualProperties
import joyfill2.text.TextColumn
import joyfill2.text.internal.TextCellImpl
import joyfill2.text.internal.TextColumnImpl
import joyfill2.text_area.TextAreaColumn
import joyfill2.text_area.internal.TextAreaCellImpl
import joyfill2.text_area.internal.TextAreaColumnImpl
import joyfill2.type
import joyfill2.unknown.UnknownColumn
import joyfill2.unknown.internal.UnknownCellImpl
import joyfill2.unknown.internal.UnknownColumnImpl

inline fun MutableMap<String, Any?>.toTableField(): TableField = TableFieldImpl(this)

inline fun MutableMap<String, Any?>.toTableSchemas(): TableSchemas = TableSchemasImpl(this)

inline fun List<Column>.toCells(wrapped: MutableMap<String, Any?>): Cells =
    CellsImpl(
        columns = this,
        wrapped = wrapped,
    )

inline fun MutableMap<String, Any?>.toTableRow(columns: List<Column>): Row = RowImpl(columns, this)

inline fun MutableMap<String, Any?>.toColumnVisualProperties(): ColumnVisualProperties = ColumnVisualPropertiesImpl(this)

inline fun MutableMap<String, Any?>.toColumn(): Column =
    when (type()) {
        Type.text -> TextColumnImpl(this)
        Type.block -> BlockColumnImpl(this)
        Type.textarea -> TextAreaColumnImpl(this)
        Type.dropdown -> DropdownColumnImpl(this)
        Type.barcode -> BarcodeColumnImpl(this)
        Type.number -> NumberColumnImpl(this)
        Type.image -> ImageColumnImpl(this)
        Type.file -> FileColumnImpl(this)
        Type.multiSelect -> MultiSelectColumnImpl(this)
        Type.date -> DateColumnImpl(this)
        Type.signature -> SignatureColumnImpl(this)
        else -> UnknownColumnImpl(this)
    }

// Cell
inline fun MutableMap<String, Any?>.toCell(column: Column): Cell =
    when (column) {
        is TextColumn -> TextCellImpl(column, this)
        is BlockColumn -> BlockCellImpl(column, this)
        is TextAreaColumn -> TextAreaCellImpl(column, this)
        is DropdownColumn -> DropdownCellImpl(column, this)
        is BarcodeColumn -> BarcodeCellImpl(column, this)
        is NumberColumn -> NumberCellImpl(column, this)
        is ImageColumn -> ImageCellImpl(column, this)
        is FileColumn -> FileCellImpl(column, this)
        is SignatureColumn -> SignatureCellImpl(column, this)
        is MultiSelectColumn -> MultiSelectCellImpl(column, this)
        is DateColumn -> DateCellImpl(column, this)
        is UnknownColumn -> UnknownCellImpl(column)
        else -> UnknownCellImpl(column)
    }