package joyfill2.signature.internal

import joyfill2.components.Component
import joyfill2.internal.AbstractValueBasedField
import joyfill2.signature.SignatureField
import joyfill2.utils.toNullableString

@PublishedApi
internal class SignatureFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), SignatureField {
    override var value: String?
        get() = wrapped[Component::value.name].toNullableString()
        set(value) {
            wrapped[Component::value.name] = value
        }
}