package joyfill2.multi_select.internal

import joyfill2.multi_select.MultiSelectColumn
import joyfill2.multi_select.MultiSelectField
import joyfill2.table.internal.column.AbstractColumn
import joyfill2.utils.JsonList
import joyfill2.utils.Option
import joyfill2.utils.toOption

@PublishedApi
internal class MultiSelectColumnImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractColumn(wrapped), MultiSelectColumn {
    override val multi: Boolean by lazy {
        wrapped[MultiSelectField::multi.name]?.toString()?.toBooleanStrict() ?: true
    }

    override val options: List<Option> =
        JsonList(wrapped[MultiSelectField::options.name]) { it.toOption() }

    override val value: MutableList<String> = run {
        val key = MultiSelectField::value.name
        val v = wrapped[key] as? MutableList<String>
        if (v == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }
}