package joyfill2.internal

import joyfill2.File
import joyfill2.Page
import joyfill2.View
import joyfill2.utils.ID
import joyfill2.utils.JsonList

@PublishedApi
internal class FileImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), File {

    override var id: String
        get() = wrapped[ID] as String
        set(value) {
            wrapped[ID] = value
        }

    override var identifier: String
        get() = wrapped[File::identifier.name] as String
        set(value) {
            wrapped[File::identifier.name] = value
        }

    override var name: String
        get() = wrapped[File::name.name] as String
        set(value) {
            wrapped[File::name.name] = value
        }

    override val pages: MutableList<Page> = JsonList(wrapped[File::pages.name]) { PageImpl(it) }

    override val pageOrder: MutableList<String> = wrapped[File::pageOrder.name] as MutableList<String>

    override val views: MutableList<View> = run {
        val key = File::views.name
        val value = wrapped[key]
        if(value==null) {
            wrapped[key] = mutableListOf<Map<String, Any?>>()
        }
        JsonList(wrapped[key]) { ViewImpl(it) }
    }
}