package joyfill2.internal

import joyfill2.FieldPosition
import joyfill2.table.internal.table.ColumnVisualProperties
import joyfill2.table.toColumnVisualProperties
import joyfill2.utils.COLUMNS
import joyfill2.utils.ID
import joyfill2.utils.JsonList
import joyfill2.utils.toNullableDouble
import joyfill2.utils.toNullableString

@PublishedApi
internal class FieldPositionImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), FieldPosition {
    override val id: String get() = wrapped[ID] as String
    override val field: String get() = wrapped[FieldPosition::field.name] as String
    override val displayType: String? get() = wrapped[FieldPosition::displayType.name].toNullableString()
    override val y get() = wrapped[FieldPosition::y.name]?.toNullableDouble() ?: 0.0
    override val x get() = wrapped[FieldPosition::x.name]?.toNullableDouble() ?: 0.0
    override val format get() = wrapped[FieldPosition::format.name] as? String
    override val fontColor: String? get() = wrapped[FieldPosition::fontColor.name].toNullableString()
    override val fontWeight: String? get() = wrapped[FieldPosition::fontWeight.name].toNullableString()
    override val primaryDisplayOnly: Boolean? get() = wrapped[FieldPosition::primaryDisplayOnly.name] as? Boolean
    override val fontSize: Double? get() = wrapped[FieldPosition::fontSize.name]?.toNullableDouble()
    override val textTransform: String? get() = wrapped[FieldPosition::textTransform.name].toNullableString()
    override val textOverflow: String? get() = wrapped[FieldPosition::textOverflow.name].toNullableString()
    override val textAlign: String? get() = wrapped[FieldPosition::textAlign.name].toNullableString()
    override val type: String get() = wrapped[FieldPosition::type.name] as String
    override val borderColor: String? get() = wrapped[FieldPosition::borderColor.name].toNullableString()
    override val backgroundColor: String? get() = wrapped[FieldPosition::backgroundColor.name].toNullableString()
    override val borderRadius: Double? get() = wrapped[FieldPosition::borderRadius.name]?.toNullableDouble()
    override val borderWidth: Double? get() = wrapped[FieldPosition::borderWidth.name]?.toNullableDouble()
    override val padding: Double? get() = wrapped[FieldPosition::padding.name]?.toNullableDouble()
    override val titleDisplay: String? get() = wrapped[FieldPosition::titleDisplay.name].toNullableString()
    override val fontStyle: String? get() = wrapped[FieldPosition::fontStyle.name].toNullableString()
    override val textDecoration: String? get() = wrapped[FieldPosition::textDecoration.name].toNullableString()
    override val columns: List<ColumnVisualProperties> by lazy {
        val data = wrapped[COLUMNS] as? MutableList<MutableMap<String, Any?>> ?: mutableListOf()
        JsonList(data) { it.toColumnVisualProperties() }
    }
}