package joyfill2.internal

import joyfill.utils.toJsonObject
import joyfill2.Mappable
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject

//@PublishedApi
abstract class AbstractMappable(
    val wrapped: MutableMap<String, Any?>
) : Mappable {

    @OptIn(ExperimentalSerializationApi::class)
    private val codec = Json {
        prettyPrint = true
        prettyPrintIndent = "  "
    }

    override fun toMap(): MutableMap<String, Any?> = wrapped

    override fun toJsonString(): String = codec.encodeToString(JsonObject.serializer(), toJsonObject())

    override fun toJsonObject(): JsonObject = toMap().toJsonObject()
}