package joyfill2.file.internal

import joyfill2.file.FileCell
import joyfill2.file.FileColumn
import joyfill2.file.FileSchema
import joyfill2.utils.Attachment
import joyfill2.utils.JsonList
import joyfill2.utils.internal.AttachmentImpl

@PublishedApi
internal class FileCellImpl(
    override val column: FileColumn,
    private val wrapped: MutableMap<String, Any?>
) : FileCell, FileSchema by column {
    override val value: MutableList<Attachment> by lazy {
        val key = column.id
        if (wrapped[key] !is List<*>) {
            wrapped[key] = mutableListOf<MutableMap<String, Any>>()
        }
        JsonList(wrapped[key]) {
            AttachmentImpl(it)
        }
    }

    override val multi: Boolean = column.multi
}