package joyfill2.conditions.internal.table

import joyfill2.conditions.internal.AbstractLogicImpl
import joyfill2.conditions.table.TableConditionDefinition
import joyfill2.conditions.table.TableLogic
import joyfill2.utils.JsonList

@PublishedApi
internal class TableLogicImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractLogicImpl(wrapped), TableLogic {
    override val conditions: MutableList<TableConditionDefinition> = run {
        val key = TableLogic::conditions.name
        if (wrapped[key] == null) {
            wrapped[key] = mutableListOf<MutableMap<String, Any?>>()
        }
        JsonList(wrapped[key]) { TableConditionDefinitionImpl(it) }
    }
}