package joyfill2.collection.internal

import joyfill2.collection.CollectionField
import joyfill2.collection.TableSchemas
import joyfill2.internal.AbstractListBasedField
import joyfill2.table.Row

@PublishedApi
internal class CollectionFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedField<Row>(wrapped), CollectionField {

    override fun factory(map: MutableMap<String, Any?>) = RowImpl(
        schema = schema,
        table = schema.root() ?: error("Collection field $title with id $id doesn't have a root table"),
        wrapped = map
    )

    override val schema: TableSchemas by lazy {
        TableSchemasImpl(wrapped[CollectionField::schema.name] as MutableMap<String, Any?>)
    }
}