package joyfill2.barcode.internal

import joyfill2.barcode.BarcodeField
import joyfill2.components.Component
import joyfill2.internal.AbstractValueBasedField
import joyfill2.utils.toNullableString

@PublishedApi
internal class BarcodeFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), BarcodeField{
    override var value: String?
        get() = wrapped[Component::value.name].toNullableString()
        set(value) {
            wrapped[Component::value.name] = value
        }
}