package joyfill2

import joyfill2.barcode.toBarcodeField
import joyfill2.block.toBlockField
import joyfill2.collection.toCollectionField
import joyfill2.components.ComponentSchema
import joyfill2.date.toDateField
import joyfill2.dropdown.toDropdownField
import joyfill2.file.toFileField
import joyfill2.image.toImageField
import joyfill2.internal.DocumentImpl
import joyfill2.internal.FieldPositionImpl
import joyfill2.internal.FormularApplicationImpl
import joyfill2.internal.FormularDefinitionImpl
import joyfill2.internal.PageImpl
import joyfill2.multi_select.toMultiSelectField
import joyfill2.number.toNumberField
import joyfill2.signature.toSignatureField
import joyfill2.table.toTableField
import joyfill2.text.toTextField
import joyfill2.text_area.toTextAreaField
import joyfill2.unknown.toUnknownField
import joyfill2.utils.toMap
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonArray
import kotlinx.serialization.json.JsonObject

// Document
inline fun MutableMap<String, Any?>.toDocument(): Document = DocumentImpl(this)
inline fun String.toDocuments(): List<Document> =
    Json.decodeFromString<JsonArray>(this).map {
        (it as JsonObject).toDocument()
    }

inline fun String.toDocument(): Document = Json.decodeFromString<JsonObject>(this).toDocument()
inline fun JsonObject.toDocument(): Document = toMap().toDocument()

// Page
inline fun MutableMap<String, Any?>.toPage(): Page = PageImpl(this)

inline fun MutableMap<String, Any?>.toFormularDefinition(): FormulaDefinition = FormularDefinitionImpl(this)

inline fun MutableMap<String, Any?>.toFormularApplication(): FormularApplication = FormularApplicationImpl(this)

// Field
inline fun MutableMap<String, Any?>.toField(): Field =
    when (type()) {
        Type.text -> toTextField()
        Type.block -> toBlockField()
        Type.textarea -> toTextAreaField()
        Type.dropdown -> toDropdownField()
        Type.barcode -> toBarcodeField()
        Type.number -> toNumberField()
        Type.table -> toTableField()
        Type.collection -> toCollectionField()
        Type.image -> toImageField()
        Type.file -> toFileField()
        Type.multiSelect -> toMultiSelectField()
        Type.date -> toDateField()
        Type.signature -> toSignatureField()
        else -> toUnknownField()
    }

// Field Position
inline fun MutableMap<String, Any?>.toPosition(): FieldPosition = FieldPositionImpl(this)

// Type
inline fun MutableMap<String, Any?>.type(): Type {
    val name =
        try {
            this[ComponentSchema::type.name] as String
        } catch (e: IllegalArgumentException) {
            Type.unknown.name
        }
    return Type.valueOf(name)
}