package joyfill.internal

import joyfill.Page
import joyfill.View
import joyfill.fields.AbstractMappable
import joyfill.toPage
import joyfill.utils.ID
import joyfill.utils.JsonList

@PublishedApi
internal class ViewImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), View {
    override val id: String get() = wrapped[ID] as String
    override val type: String = wrapped[View::type.name] as String
    override val pages: MutableList<Page> = run {
        val key = View::pages.name
        if (wrapped[key] == null) {
            wrapped[key] = mutableListOf<MutableMap<String, Any?>>()
        }
        JsonList(wrapped[key]) { it.toPage() }
    }
    override val pageOrder: List<String> = run {
        val key = View::pageOrder.name
        if (wrapped[key] == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as List<String>
    }
}