package joyfill.internal

import joyfill.FieldPosition
import joyfill.MutablePage
import joyfill.Page
import joyfill.conditions.Logic
import joyfill.conditions.internal.LogicImpl
import joyfill.fields.AbstractMappable
import joyfill.fields.Field
import joyfill.toPosition
import joyfill.utils.ID
import joyfill.utils.JsonList
import joyfill.utils.POSITIONS

@PublishedApi
internal class PageImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), MutablePage {
    override var id: String
        get() = wrapped[ID] as String
        set(value) {
            wrapped[ID] = value
        }
    override var name: String
        get() = wrapped[Page::name.name] as String
        set(value) {
            wrapped[Page::name.name] = value
        }

    override var identifier: String
        get() = wrapped[Field::identifier.name]?.toString() ?: ""
        set(value) {
            wrapped[Field::identifier.name] = value
        }

    override val positions: MutableList<FieldPosition> = JsonList(wrapped[POSITIONS]) { it.toPosition() }

    override val logic: Logic? get() = wrapped[Page::logic.name]?.let {
        LogicImpl(it as MutableMap<String, Any?>)
    }

    override var hidden: Boolean
        get() = wrapped[Page::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Page::hidden.name] = value
        }

    override fun toString(): String = "Page(name = $name, hidden = $hidden)"
}