package joyfill.internal

import joyfill.FieldPosition
import joyfill.fields.AbstractMappable
import joyfill.fields.table.ColumnPosition
import joyfill.toColumnPosition
import joyfill.utils.COLUMNS
import joyfill.utils.ID
import joyfill.utils.JsonList

@PublishedApi
internal class FieldPositionImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), FieldPosition {
    override val id: String by lazy { wrapped[ID] as String }
    override val field: String by lazy { wrapped[FieldPosition::field.name] as String }
    override val displayType: String? by lazy { wrapped[FieldPosition::displayType.name] as? String }
    override val y: Double by lazy { wrapped[FieldPosition::y.name]?.toString()?.toDouble() ?: 0.0 }
    override val x: Double by lazy { wrapped[FieldPosition::x.name]?.toString()?.toDouble() ?: 0.0 }
    override val format: String? by lazy { wrapped[FieldPosition::format.name] as? String }
    override val fontColor: String? by lazy { wrapped[FieldPosition::fontColor.name] as? String }
    override val fontWeight: String? by lazy { wrapped[FieldPosition::fontWeight.name] as? String }
    override val fontSize: Double? by lazy { wrapped[FieldPosition::fontSize.name]?.toString()?.toDouble() }
    override val textTransform: String? by lazy { wrapped[FieldPosition::textTransform.name] as? String }
    override val textOverflow: String? by lazy { wrapped[FieldPosition::textOverflow.name] as? String }
    override val textAlign: String? by lazy { wrapped[FieldPosition::textAlign.name] as? String }
    override val columns: List<ColumnPosition> by lazy {
        val data = wrapped[COLUMNS] as? MutableList<MutableMap<String, Any?>> ?: mutableListOf()
        JsonList(data) { it.toColumnPosition() }
    }
}