package joyfill2.utils.joyobject

import joyfill2.tools.joyobject.MapObject

fun JoyObject(map: MutableMap<String, Any?> = mutableMapOf()): JoyMap = MapObject(map)

fun JoyObject(value: Number) = JoyNumber(value.toDouble())

internal fun Any?.toJoyObject(): JoyObject = when (this) {
    is Map<*, *> -> MapObject(toMutableMap() as MutableMap<String, Any?>)
    is List<*> -> ListObject(toMutableList())
    is Number -> JoyNumber(toDouble())
    is String -> JoyString(this)
    is Boolean -> JoyBoolean(this)
    null -> JoyNull
    else -> throw IllegalArgumentException("Unsupported type: ${this::class.simpleName}")
}