package joyfill2.utils.internal

import joyfill2.internal.AbstractMappable
import joyfill2.table.Column
import joyfill2.utils.ID
import joyfill2.utils.Option
import joyfill2.utils.joyobject.JoyMap
import joyfill2.utils.joyobject.JoyObject


internal class OptionImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), Option {
    override val id: String get() = wrapped[ID] as String
    override val deleted: Boolean get() = (wrapped[Option::deleted.name] as? Boolean) == true
    override val value: String get() = wrapped[Option::value.name] as String
    override val color: String? get() = wrapped[Option::color.name] as? String
    override val metadata: JoyMap by lazy {
        val key = Column::metadata.name
        val map = wrapped[key] as? MutableMap<String, Any?>
        if(map==null) {
            wrapped[key] = mutableMapOf<String,Any?>()
        }
        JoyObject(wrapped[key] as MutableMap<String, Any?>)
    }

    override fun equals(other: Any?): Boolean = other is Option && id == other.id
}