package joyfill2.signature.internal

import joyfill2.signature.SignatureCell
import joyfill2.signature.SignatureColumn
import joyfill2.signature.SignatureSchema
import joyfill2.utils.toNullableString

@PublishedApi
internal class SignatureCellImpl(
    override val column: SignatureColumn,
    private val wrapped: MutableMap<String, Any?>
) : SignatureCell, SignatureSchema by column {
    override var value: String?
        get() = wrapped[column.id].toNullableString()
        set(value) {
            wrapped[column.id] = value
        }
}