package joyfill2.number.internal

import joyfill2.number.NumberCell
import joyfill2.number.NumberColumn
import joyfill2.number.NumberSchema
import joyfill2.utils.toDouble

@PublishedApi
internal class NumberCellImpl(
    override val column: NumberColumn,
    private val wrapped: MutableMap<String, Any?>
) : NumberCell, NumberSchema by column {
    override var value: Double?
        get() = wrapped[column.id]?.toDouble()
        set(value) {
            wrapped[column.id] = value
        }
}