package joyfill2.internal

import joyfill2.ToolTip
import joyfill2.utils.TIP_DESCRIPTION
import joyfill2.utils.TIP_TITLE
import joyfill2.utils.TIP_VISIBLE

internal class ToolTipImpl(
    private val wrapper: MutableMap<String, Any?>,
) : ToolTip {
    override var title
        get() = wrapper[TIP_TITLE]?.toString().orEmpty()
        set(value) {
            wrapper[TIP_TITLE] = value
        }
    override var visible: Boolean
        get() = wrapper[TIP_VISIBLE]?.toString()?.toBoolean() == true
        set(value) {
            wrapper[TIP_VISIBLE] = value
        }

    override var description
        get() =  wrapper[TIP_DESCRIPTION]?.toString().orEmpty()
        set(value) {
            wrapper[TIP_DESCRIPTION] = value
        }
}