package joyfill2.internal

import joyfill2.Document
import joyfill2.Field
import joyfill2.File
import joyfill2.Stage
import joyfill2.toDocument
import joyfill2.toField
import joyfill2.utils.ID
import joyfill2.utils.JsonList
import joyfill2.utils.toNullableString

@PublishedApi
internal class DocumentImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Document {
    override var id: String
        get() = wrapped[ID] as String
        set(value) {
            wrapped[ID] = value
        }

    override var stage: Stage
        get() = Stage.valueOf(wrapped[Document::stage.name] as String)
        set(value) {
            wrapped[Document::stage.name] = value.name
        }

    override var identifier: String
        get() = wrapped[Document::identifier.name].toNullableString() ?: id
        set(value) {
            wrapped[Document::identifier.name] = value
        }

    override var name: String
        get() = wrapped[Document::name.name] as String
        set(value) {
            wrapped[Document::name.name] = value
        }

    override val files: MutableList<File> = JsonList(wrapped[Document::files.name]) { FileImpl(it) }

    override val fields: MutableList<Field> by lazy {
        JsonList(wrapped[Document::fields.name]) { it.toField() }
    }

    override fun <R> get(key: String): R = wrapped[key] as R

    override fun set(key: String, value: Any?) {
        wrapped[key] = value
    }

    override fun copy(): Document = toJsonString().toDocument()
}