package joyfill2.internal

import joyfill2.Field
import joyfill2.ToolTip
import joyfill2.conditions.field.FieldLogic
import joyfill2.conditions.internal.field.FieldLogicImpl
import joyfill2.schemas.internal.AbstractSchema
import joyfill2.table.Column
import joyfill2.utils.ID
import joyfill2.utils.joyobject.JoyMap
import joyfill2.utils.joyobject.JoyObject

internal abstract class AbstractField(
    wrapped: MutableMap<String, Any?>
) : AbstractSchema(wrapped), Field {
    override var id: String
        get() = wrapped[ID] as String
        set(value) {
            wrapped[ID] = value
        }

    override var title: String
        get() = wrapped[Field::title.name] as String
        set(value) {
            wrapped[Field::title.name] = value
        }

    override var identifier: String
        get() = wrapped[Field::identifier.name].toString()
        set(value) {
            wrapped[Field::identifier.name] = value
        }

    override val disabled: Boolean
        get() = wrapped[Field::disabled.name]?.toString()?.toBoolean() == true

    override var hidden: Boolean
        get() = wrapped[Field::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Field::hidden.name] = value
        }

    override val initialHiddenState: Boolean = wrapped[Field::hidden.name]?.toString()?.toBoolean() == true

    override var tip: ToolTip
        get() = ToolTipImpl(wrapped)
        set(value) {
            wrapped[Field::tip.name] = value
        }

    override val logic: FieldLogic? get() = wrapped[Field::logic.name]?.let { FieldLogicImpl(it as MutableMap<String, Any?>) }

    override val formula: String?
        get() = wrapped[Field::formula.name]?.toString()

    override val metadata: JoyMap by lazy {
        val key = Column::metadata.name
        val map = wrapped[key] as? MutableMap<String, Any?>
        if (map == null) {
            wrapped[key] = mutableMapOf<String, Any?>()
        }
        JoyObject(wrapped[key] as MutableMap<String, Any?>)
    }
}